<?php

namespace App\Filament\Resources;

use App\Filament\Resources\SecretariaUnidadeResource\Pages;
use App\Filament\Resources\SecretariaUnidadeResource\RelationManagers;
use App\Models\SecretariaUnidade;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class SecretariaUnidadeResource extends Resource
{
    protected static ?string $model = SecretariaUnidade::class;
    protected static ?string $navigationGroup = 'Administração';

    protected static ?string $navigationIcon = 'heroicon-o-map-pin';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Select::make('secretarias_id')
                ->label('Secretaria')
                ->relationship(name: 'secretaria', titleAttribute: 'nome') // usa belongsTo
                ->searchable()
                ->preload()
                ->required(),

            Forms\Components\TextInput::make('nome')
                ->label('Nome')
                ->maxLength(45)
                ->required(),
            Forms\Components\TextInput::make('horario_atendimento')->label('Horário de Atendimento')->maxLength(150),
            Forms\Components\TextInput::make('endereco')->label('Endereço')->maxLength(150),
            Forms\Components\TextInput::make('telefone')->label('Telefone')->maxLength(150),
            Forms\Components\TextInput::make('email')->label('E-mail')->email()->maxLength(100),
        ]);
    }

    public static function table(Tables\Table $table): Tables\Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('secretaria.nome')->label('Secretaria')->sortable()->searchable(),
                Tables\Columns\TextColumn::make('nome')->label('Unidade')->sortable()->searchable(),
                Tables\Columns\TextColumn::make('telefone')->label('Telefone'),
                Tables\Columns\TextColumn::make('email')->label('E-mail'),
            ])
            ->filters([
                Tables\Filters\SelectFilter::make('secretaria')
                    ->label('Filtrar por Secretaria')
                    ->relationship('secretaria', 'nome'),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListSecretariaUnidades::route('/'),
            'create' => Pages\CreateSecretariaUnidade::route('/create'),
            'edit' => Pages\EditSecretariaUnidade::route('/{record}/edit'),
        ];
    }
}
