<?php

namespace App\Http\Controllers;

use App\Models\Videos;
use Illuminate\Http\Request;

class VideosController extends Controller
{
    public function index(Request $request){

        $offset = $request->query('offset', 0);  // valor padrão = 0
        $limit  = $request->query('limit', 10);  // valor padrão = 10

        $noticias = Videos::with([ 'categorias'])
            ->skip($offset)
            ->take($limit)
            ->get();
        return $noticias;

    }

    public function list(Request $request){
        return Videos::with('categorias')->paginate();
    }



    public function slug($slug){
        $noticia = Videos::with(['categorias'])
            ->where('slug', $slug)
            ->firstOrFail();

        $noticia->increment('visualizacoes');

        return $noticia;
    }
}
