<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Categoria extends Model
{
    use HasFactory;

    protected $table = 'categoria'; // singular conforme migration

    protected $fillable = ['nome'];

    public function noticias()
    {
        return $this->belongsToMany(
            Noticia::class,
            'noticias_categorias',
            'categoria_id',
            'noticias_id'
        )->withTimestamps();
    }
    public function video()
    {
        return $this->belongsToMany(
            Videos::class,
            'video_categorias',
            'categoria_id',
            'video_id'
        )->withTimestamps();
    }
}
