<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GaleriaImagens extends Model
{
    use HasFactory;

    protected $table = 'galeria_imagens';

    protected $fillable = ['nome', 'link', 'galeria_id', 'noticias_id'];

    public function galeria()
    {
        return $this->belongsTo(Galeria::class, 'galeria_id');
    }

    public function noticia()
    {
        return $this->belongsTo(Noticia::class, 'noticias_id');
    }
}
