<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NoticiaScretaria extends Model
{
    use HasFactory;

    protected $table = 'noticia_scretarias';

    protected $fillable = [
        'noticias_id',
        'secretarias_id',
    ];

    public function noticia()
    {
        return $this->belongsTo(Noticia::class, 'noticias_id');
    }

    public function secretaria()
    {
        return $this->belongsTo(Secretarias::class, 'secretarias_id');
    }
}
