<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('secretarias', function (Blueprint $table) {
            $table->id();
            $table->string('nome', 150);
            $table->string('nome_secretario', 150);
            $table->string('email_secretaria', 150);
            $table->string('endereco', 250);
            $table->string('horario_funcionamento', 150);
            $table->string('telefone', 150);
            $table->text('descricao')->nullable();
            $table->string('foto_secretario', 250)->nullable();
            $table->string('latitude', 45)->nullable();
            $table->string('longitude', 45)->nullable();
            $table->integer('visualizacoes')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('secretarias');
    }
};
