<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class AmparoLegalSeed extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $now = now();
        $items = [
            ['nome' => '14.133/2021'],
            ['nome' => '13.303/2016'],
            ['nome' => '8.666/1993'],

        ];

        foreach ($items as $item) {
            DB::table('amparo_legal')->updateOrInsert(
                ['nome' => $item['nome']], // evita duplicado
                ['created_at' => $now, 'updated_at' => $now]
            );
        }
    }
}
