<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ModoDisputaSeed extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $now = now();
        $items = [
            ['nome' => 'Aberto'],
            ['nome' => 'Fechado'],
            ['nome' => 'Aberto e Fechado'],

        ];

        foreach ($items as $item) {
            DB::table('modo_disputa')->updateOrInsert(
                ['nome' => $item['nome']], // evita duplicado
                ['created_at' => $now, 'updated_at' => $now]
            );
        }
    }
}
