<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Seeder;

class TipoModalidadeSeed extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $now = now();

        $nomes = [
            'Carta Convite',
            'Chamamento Público',
            'Concorrência Eletrônica',
            'Concorrência Pública',
            'Convênio',
            'Credenciamento',
            'Dispensa de Licitação',
            'Dispensa Eletrônica',
            'Leilão - Presencial',
            'Pregão Eletrônico',
            'Pregão Presencial',
            'Tomada de Preço',
        ];

        foreach ($nomes as $nome) {
            DB::table('tipo_modalidade')->updateOrInsert(
                ['nome' => $nome],                // evita duplicado
                ['created_at' => $now, 'updated_at' => $now]
            );
        }
    }
}
