<?php

namespace App\Filament\Resources;

use App\Filament\Resources\LicitacaoResource\Pages;
use App\Filament\Resources\LicitacaoResource\RelationManagers;

use App\Models\Licitacao;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Forms\Components\Split;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\RichEditor;


class LicitacaoResource extends Resource
{
    protected static ?string $model = Licitacao::class;
    protected static ?string $navigationGroup = 'Compras';

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Split::make([
                    Section::make([
                        TextInput::make('numero_licitacao')
                            ->maxLength(255)

                            ->default(null),
                        TextInput::make('numero_edital')
                            ->maxLength(255)

                            ->default(null),

                        TextInput::make('numero_processo')
                            ->maxLength(255)
                            ->default(null),
                        DateTimePicker::make('data_publicacao'),
                        DateTimePicker::make('data_realizacao'),
                        DateTimePicker::make('data_recebimento'),
                        TextInput::make('local')
                            ->maxLength(255)
                            ->default(null),
                        TextInput::make('valor')
                            ->maxLength(255)
                            ->default(null),
                        RichEditor::make('descricao')
                            ->columnSpanFull(),

                    ])->columns([
                        'sm' => 3,
                        'xl' => 6,
                        '2xl' => 2,
                    ]),
                    Forms\Components\Section::make([
                        Select::make('tipo_situacao_id')
                            ->label('Situação')
                            ->relationship('tipoSituacao', 'nome')
                            ->searchable()
                            ->preload()
                            ->native(false),
                        Select::make('modo_disputa_id')
                            ->label('Modo de Disputa')
                            ->relationship('modoDisputa', 'nome')
                            ->searchable()
                            ->preload()
                            ->native(false),
                        Select::make('tipo_modalidade_id')
                            ->label('Modalidade')
                            ->relationship('tipoModalidade', 'nome')
                            ->searchable()
                            ->preload()
                            ->native(false),
                        Select::make('amparo_legal_id')
                            ->label('Amparo Legal')
                            ->relationship('amparoLegal', 'nome')
                            ->searchable()
                            ->preload()
                            ->native(false),
                    ])->grow(false),
                ])->from('md')



            ])->columns(1);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('numero_licitacao')
                    ->searchable(),
                Tables\Columns\TextColumn::make('numero_edital')
                    ->searchable(),
                Tables\Columns\TextColumn::make('numero_processo')
                    ->searchable(),
                Tables\Columns\TextColumn::make('data_publicacao')
                    ->label('Publicação')
                    ->dateTime('d/m/Y H:i')
                    ->sortable(),
                Tables\Columns\TextColumn::make('data_realizacao')
                    ->label('Realização')
                    ->dateTime('d/m/Y H:i')
                    ->sortable(),
                Tables\Columns\TextColumn::make('data_recebimento')
                    ->label('Recebimento')
                    ->dateTime('d/m/Y H:i')
                    ->sortable(),
                Tables\Columns\TextColumn::make('local')
                    ->searchable(),
                Tables\Columns\TextColumn::make('valor')
                    ->searchable(),
                Tables\Columns\TextColumn::make('tipoSituacao.nome')
                    ->label('Situação')
                    ->searchable()
                    ->sortable()
                    ->toggleable(),
                Tables\Columns\TextColumn::make('modoDisputa.nome')
                    ->label('Modo de Disputa')
                    ->searchable()
                    ->sortable()
                    ->toggleable(),
                Tables\Columns\TextColumn::make('tipoModalidade.nome')
                    ->label('Modalidade')
                    ->searchable()
                    ->sortable()
                    ->toggleable(),
                Tables\Columns\TextColumn::make('amparoLegal.nome')
                    ->label('LEI')
                    ->searchable()
                    ->sortable()
                    ->toggleable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            RelationManagers\ArquivosLicitacaoRelationManager::class
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListLicitacaos::route('/'),
            'create' => Pages\CreateLicitacao::route('/create'),
            'edit' => Pages\EditLicitacao::route('/{record}/edit'),
        ];
    }
}
