<?php

namespace App\Filament\Resources\LicitacaoResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Components\Select;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ArquivosLicitacaoRelationManager extends RelationManager
{
    protected static string $relationship = 'arquivosLicitacao'; // método no Model Secretaria

    protected static ?string $title = 'Arquivos ';

    public function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\Group::make([
                Forms\Components\FileUpload::make('link')
                    ->label('Arquivo')

                    ->disk('public')
                    ->directory('licitacao/editais')
                    ->imageEditor()
                    ->downloadable(),
            ])->columnSpan(4),

                Forms\Components\TextInput::make('descricao')
                    ->label('Nome')
                    ->columnSpan(1)
                    ->required(),
                Select::make('tipo_arquivo_id')
                    ->label('Situação')
                    ->relationship('tipoArquivo', 'nome')
                    ->searchable()
                    ->preload()
                    ->native(false),



        ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\IconColumn::make('link')
                    ->icon('heroicon-o-arrow-down-on-square')
                    ->color('info'),
                Tables\Columns\TextColumn::make('descricao')->label('Nome')->searchable()->sortable(),
                Tables\Columns\ToggleColumn::make('status')->label('Publicado')->searchable()->sortable(),
                Tables\Columns\TextColumn::make('tipoArquivo.nome')
                    ->label('Tipo de Arquivo')
                    ->searchable()
                    ->sortable()
                    ->toggleable(),
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make(), // cria unidade já vinculada à secretaria
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\DeleteBulkAction::make(),
            ]);
    }
}
