<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ArquivosLicitacao extends Model
{
    use HasFactory;

    protected $table = 'arquivos_licitacao';

    protected $fillable = [
        'link',
        'descricao',
        'status',
        'licitacao_id',
        'tipo_arquivo_id',
    ];

    protected $casts = [
        'status' => 'integer', // ajuste para boolean se preferir
    ];

    public function licitacao()
    {
        return $this->belongsTo(Licitacao::class, 'licitacao_id');
    }

    public function tipoArquivo()
    {
        return $this->belongsTo(TipoArquivo::class, 'tipo_arquivo_id');
    }
}
