<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class EventosSecretaria extends Model
{
    protected $table = 'eventos_secretarias';

    protected $fillable = [
        'evento_id',
        'secretarias_id',
    ];

    public function noticia()
    {
        return $this->belongsTo(Eventos::class, 'evento_id');
    }

    public function secretaria()
    {
        return $this->belongsTo(Secretarias::class, 'secretarias_id');
    }
}
