<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Licitacao extends Model
{
    use HasFactory;

    protected $table = 'licitacao';

    protected $fillable = [
        'numero_licitacao',
        'numero_edital',
        'numero_processo',
        'data_publicacao',
        'data_realizacao',
        'data_recebimento',
        'local',
        'descricao',
        'valor',
        'tipo_situacao_id',
        'modo_disputa_id',
        'tipo_modalidade_id',
        'amparo_legal_id',
    ];

    public function tipoSituacao()
    {
        return $this->belongsTo(TipoSituacao::class, 'tipo_situacao_id');
    }

    public function modoDisputa()
    {
        return $this->belongsTo(ModoDisputa::class, 'modo_disputa_id');
    }

    public function tipoModalidade()
    {
        return $this->belongsTo(TipoModalidade::class, 'tipo_modalidade_id');
    }

    public function amparoLegal()
    {
        return $this->belongsTo(AmparoLegal::class, 'amparo_legal_id');
    }

    public function arquivosLicitacao()
    {
        return $this->hasMany(ArquivosLicitacao::class, 'licitacao_id');
    }
}
