<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('galeria_imagens', function (Blueprint $table) {
            $table->id();
            $table->string('nome', 150)->nullable(); // legenda/alt
            $table->string('link', 255);             // caminho do arquivo

            // FK para galeria OU notícia (ambos nullable para funcionar independente)
            $table->foreignId('galeria_id')
                ->nullable()
                ->constrained('galeria')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            $table->foreignId('noticias_id')
                ->nullable()
                ->constrained('noticias')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            $table->timestamps();

            $table->index('galeria_id');
            $table->index('noticias_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('galeria_imagens');
    }
};
