<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('licitacao', function (Blueprint $table) {
            $table->id();

            $table->string('numero_licitacao')->nullable();
            $table->string('numero_edital')->nullable();
            $table->string('numero_processo')->nullable();

            $table->dateTime('data_publicacao')->nullable();
            $table->dateTime('data_realizacao')->nullable();
            $table->dateTime('data_recebimento')->nullable();

            $table->string('local')->nullable();
            $table->text('descricao')->nullable();
            $table->decimal('valor', 15, 2)->nullable();
            $table->integer('visualizacoes')->default(1);

            // FKs
            $table->foreignId('tipo_situacao_id')->nullable()
                  ->constrained('tipo_situacao')->cascadeOnUpdate()->nullOnDelete();

            $table->foreignId('modo_disputa_id')->nullable()
                  ->constrained('modo_disputa')->cascadeOnUpdate()->nullOnDelete();

            $table->foreignId('tipo_modalidade_id')->nullable()
                  ->constrained('tipo_modalidade')->cascadeOnUpdate()->nullOnDelete();

            $table->foreignId('amparo_legal_id')->nullable()
                  ->constrained('amparo_legal')->cascadeOnUpdate()->nullOnDelete();

            $table->timestamps();

            $table->index(['numero_licitacao', 'numero_edital', 'numero_processo']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('licitacao');
    }
};
