<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('noticia_scretarias', function (Blueprint $table) {
            $table->id();

            $table->foreignId('noticias_id')
                ->constrained('noticias')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            $table->unsignedBigInteger('secretarias_id');
            $table->foreign('secretarias_id')
                ->references('id')->on('secretarias')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            // Evita pares duplicados
            $table->unique(['noticias_id', 'secretarias_id']);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('noticia_scretarias');
    }
};
