<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('noticias_categorias', function (Blueprint $table) {
            $table->id();

            $table->foreignId('noticias_id')
                ->constrained('noticias')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            $table->foreignId('categoria_id')
                ->constrained('categoria')
                ->cascadeOnUpdate()
                ->cascadeOnDelete();

            // Evita pares duplicados
            $table->unique(['noticias_id', 'categoria_id']);

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('noticias_categorias');
    }
};
