<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('eventos', function (Blueprint $table) {
            $table->id();
            $table->string('nome');
            $table->string('capa');
            $table->enum('status', [
                'pendente',
                'em_andamento',
                'concluido',
                'cancelado'
            ])->default('pendente');
            $table->dateTime('data_hora_inicio');
            $table->dateTime('data_hora_fim');
            $table->text('descricao');
            $table->string('slug');
            $table->integer('visualizacoes')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('eventos');
    }
};
